//parser_atp_sst_authentication.h

#ifndef PARSER_ATP_SST_AUTHENTICATION_H
#define PARSER_ATP_SST_AUTHENTICATION_H


/************************ Includes *****************************/
#include "msg_defs.h"
#include "SST_SEP_TST.h"
/************************ Defines ******************************/

/* HOST CONNECTIVITY TEST COMMAND */
//#define	DX_SEP_HOST_SEP_CONNECTIVITY_MSG_LENGTH_IN_WORDS	(1)/* msg len in words *///
//#define DX_SEP_HOST_SEP_CONNECTIVITY_MSG_COUNTER_OFFSET		(DX_SEP_HOST_SEP_BASE_MSG_OFFSET)/* this is the first param: 1 word  */

typedef enum
{
	RSA_DSIZE_OFFSET                       = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 0),
	RSA_ESIZE_OFFSET                       = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 1),
	RSA_NSIZE_OFFSET                       = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 2),
	RSA_CHALENGE_BUFF_SIZE_OFFSET          = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 3),
	RSA_NEW_CHALENGE_BUFF_SIZE_OFFSET      = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 4),
	RSA_SIGNED_CHALENGE_BUFF_SIZE_OFFSET   = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 5),
	RSA_DATA_SIZE_OFFSET                   = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 6),
	RSA_START_BUFFERS_OFFSET               = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 7)

}RsaAsymAuthenticator_Parameters_Offsets;

typedef enum
{
	AES_KEY_TYPE_OFFSET                = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 0),
	AES_CHALENGE_BUFF_SIZE_OFFSET      = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 1),
	AES_NEW_CHALENGE_BUFF_SIZE_OFFSET  = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 2),
	AES_DATA_SIZE_OFFSET               = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 3)         

}AesAsymAuthenticator_Parameters_Offsets;

typedef enum
{
	ECC_PUB_KEY_SIZE_OFFSET               = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 0),
	ECC_PRIV_KEY_SIZE_OFFSET              = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 1),
	ECC_NSIZE_OFFSET                      = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 2),
	ECC_CHALENGE_BUFF_SIZE_OFFSET         = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 3),
	ECC_NEW_CHALENGE_BUFF_SIZE_OFFSET     = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 4),
	ECC_SIGNED_CHALENGE_BUFF_SIZE_OFFSET  = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 5),
	ECC_DATA_SIZE_OFFSET                  = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 6)    

}ECCAsymAuthenticator_Parameters_Offsets;

/* PasswordAuthenticator offsets of the parameters in the message (in words) */
typedef enum
{
	MASTER_PASSW_SIZE_OFFSET            = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 0),
	SECOND_PASSW_SIZE_OFFSET            = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 1),
	NEW_SECOND_PASSW_SIZE_OFFSET        = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 2),
	PAS_DATA_SIZE_OFFSET                = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 3),
	MASTER_MAX_NUM_OF_TRIALS_OFFSET     = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 4),
	SECOND_MAX_NUM_OF_TRIALS_OFFSET     = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 5),
	NEW_SECOND_MAX_NUM_OF_TRIALS_OFFSET = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 6),
	START_BUFFERS_OFFSET                = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 7)

}PasswordAuthenticator_Parameters_Offsets;


DxUint32_t DX_SEP_SST_PARSER_PasswordAuthenticator(DxUint32_t* msg);
DxUint32_t DX_SEP_SST_PARSER_RsaAsymAuthenticator(DxUint32_t* msg);
/*****************************************************************************
* Function Name:
*  DX_SEP_SST_PARSER_AesKeyAsymAuthenticator
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application AES not integrated
* AES function.
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. extract parameters from the message 
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/ 


DxUint32_t DX_SEP_SST_PARSER_AesKeyAsymAuthenticator(DxUint32_t* msg);
/*****************************************************************************
* Function Name:
*  DX_SEP_SST_PARSER_ECCAsymAuthenticator
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application AES not integrated
* AES function.
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. extract parameters from the message 
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/ 


DxUint32_t DX_SEP_SST_PARSER_ECCAsymAuthenticator(DxUint32_t* msg);
#endif
